"""
Przykład z podrozdziału "Programowanie asynchroniczne"
pokazujący, jak dwie korutyny współpracują, zwalniając
sterowanie na rzecz pętli zdarzeń po wywołaniach blokujących.

"""
import asyncio
import random


async def waiter(name):
    for _ in range(4):
        time_to_sleep = random.randint(1, 3) / 4
        await asyncio.sleep(time_to_sleep)
        print(f"{name} oczekiwał {time_to_sleep} s")


async def main():
    await asyncio.gather(waiter("pierwszy"), waiter("drugi"))


if __name__ == "__main__":
    loop = asyncio.get_event_loop()
    loop.run_until_complete(main())
    loop.close()
